'use strict';

/* --------------------------------------------------------------
 editor_values.js 2016-09-06
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

jse.libs.editor_values = jse.core.editor_values || {};

/**
 * ## Editor Values Library
 *
 * This library provides a common API for editor widget values manipulation.
 *
 * @module Admin/Libs/editor_values
 * @exports jse.libs.editor_values
 */
(function (exports) {

    'use strict';

    /**
     * Editor Get Value Methods
     *
     * @type {Object}
     */

    var getValue = {
        ckeditor: function ckeditor($textarea) {
            var name = $textarea.attr('name');
            var instance = CKEDITOR.instances[name];
            return instance.getData();
        },
        codemirror: function codemirror($textarea) {
            var instance = $textarea.siblings('.CodeMirror')[0].CodeMirror;
            return instance.getDoc().getValue();
        }
    };

    /**
     * Editor Set Value Methods
     *
     * @type {Object}
     */
    var setValue = {
        ckeditor: function ckeditor($textarea, value) {
            var name = $textarea.attr('name');
            var instance = CKEDITOR.instances[name];
            instance.setData(value);
        },
        codemirror: function codemirror($textarea, value) {
            var instance = $textarea.siblings('.CodeMirror')[0].CodeMirror;
            instance.getDoc().setValue(value);
        }
    };

    /**
     * Get Editor Value
     *
     * @param {jQuery} $textarea Textarea selector from which the value will be returned.
     *
     * @return {String} Returns the editor value.
     */
    exports.getValue = function ($textarea) {
        var type = $textarea.data('editorType');

        if (!getValue[type]) {
            throw new Error('Provided editor element does not have the supported types: ' + type);
        }

        return getValue[type]($textarea);
    };

    /**
     * Set Editor Value
     *
     * @param {jQuery} $textarea Textarea selector to which the value will be set.
     * @param {String} value The new value of the editor.
     */
    exports.setValue = function ($textarea, value) {
        var type = $textarea.data('editorType');

        if (!getValue[type]) {
            throw new Error('Provided editor element does not have the supported types: ' + type);
        }

        setValue[type]($textarea, value);
    };
})(jse.libs.editor_values);
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
